import { getPickersLocalization } from './utils/getPickersLocalization';
var views = {
  hours: 'שעות',
  minutes: 'דקות',
  seconds: 'שניות',
  meridiem: 'מרידיאם'
};
var heILPickers = {
  // Calendar navigation
  previousMonth: 'חודש קודם',
  nextMonth: 'חודש הבא',
  // View navigation
  openPreviousView: 'תצוגה קודמת',
  openNextView: 'תצוגה הבאה',
  calendarViewSwitchingButtonAriaLabel: function calendarViewSwitchingButtonAriaLabel(view) {
    return view === 'year' ? 'תצוגת שנה פתוחה, מעבר לתצוגת לוח שנה' : 'תצוגת לוח שנה פתוחה, מעבר לתצוגת שנה';
  },
  // DateRange placeholders
  start: 'תחילה',
  end: 'סיום',
  // Action bar
  cancelButtonLabel: 'ביטול',
  clearButtonLabel: 'ניקוי',
  okButtonLabel: 'אישור',
  todayButtonLabel: 'היום',
  // Toolbar titles
  datePickerToolbarTitle: 'בחירת תאריך',
  dateTimePickerToolbarTitle: 'בחירת תאריך ושעה',
  timePickerToolbarTitle: 'בחירת שעה',
  dateRangePickerToolbarTitle: 'בחירת טווח תאריכים',
  // Clock labels
  clockLabelText: function clockLabelText(view, time, adapter) {
    return "\u05D1\u05D7\u05D9\u05E8\u05EA ".concat(views[view], ". ").concat(time === null ? 'לא נבחרה שעה' : "\u05D4\u05E9\u05E2\u05D4 \u05D4\u05E0\u05D1\u05D7\u05E8\u05EA \u05D4\u05D9\u05D0 ".concat(adapter.format(time, 'fullTime')));
  },
  hoursClockNumberText: function hoursClockNumberText(hours) {
    return "".concat(hours, " \u05E9\u05E2\u05D5\u05EA");
  },
  minutesClockNumberText: function minutesClockNumberText(minutes) {
    return "".concat(minutes, " \u05D3\u05E7\u05D5\u05EA");
  },
  secondsClockNumberText: function secondsClockNumberText(seconds) {
    return "".concat(seconds, " \u05E9\u05E0\u05D9\u05D5\u05EA");
  },
  // Digital clock labels
  selectViewText: function selectViewText(view) {
    return "\u05D1\u05D7\u05D9\u05E8\u05EA ".concat(views[view]);
  },
  // Calendar labels
  calendarWeekNumberHeaderLabel: 'שבוע מספר',
  calendarWeekNumberHeaderText: '#',
  calendarWeekNumberAriaLabelText: function calendarWeekNumberAriaLabelText(weekNumber) {
    return "\u05E9\u05D1\u05D5\u05E2 ".concat(weekNumber);
  },
  calendarWeekNumberText: function calendarWeekNumberText(weekNumber) {
    return "".concat(weekNumber);
  },
  // Open picker labels
  openDatePickerDialogue: function openDatePickerDialogue(value, utils) {
    return value !== null && utils.isValid(value) ? "\u05D1\u05D7\u05D9\u05E8\u05EA \u05EA\u05D0\u05E8\u05D9\u05DA, \u05D4\u05EA\u05D0\u05E8\u05D9\u05DA \u05E9\u05E0\u05D1\u05D7\u05E8 \u05D4\u05D5\u05D0 ".concat(utils.format(value, 'fullDate')) : 'בחירת תאריך';
  },
  openTimePickerDialogue: function openTimePickerDialogue(value, utils) {
    return value !== null && utils.isValid(value) ? "\u05D1\u05D7\u05D9\u05E8\u05EA \u05E9\u05E2\u05D4, \u05D4\u05E9\u05E2\u05D4 \u05E9\u05E0\u05D1\u05D7\u05E8\u05D4 \u05D4\u05D9\u05D0 ".concat(utils.format(value, 'fullTime')) : 'בחירת שעה';
  },
  // fieldClearLabel: 'Clear value',

  // Table labels
  timeTableLabel: 'בחירת שעה',
  dateTableLabel: 'בחירת תאריך',
  // Field section placeholders
  fieldYearPlaceholder: function fieldYearPlaceholder(params) {
    return 'Y'.repeat(params.digitAmount);
  },
  fieldMonthPlaceholder: function fieldMonthPlaceholder(params) {
    return params.contentType === 'letter' ? 'MMMM' : 'MM';
  },
  fieldDayPlaceholder: function fieldDayPlaceholder() {
    return 'DD';
  },
  fieldWeekDayPlaceholder: function fieldWeekDayPlaceholder(params) {
    return params.contentType === 'letter' ? 'EEEE' : 'EE';
  },
  fieldHoursPlaceholder: function fieldHoursPlaceholder() {
    return 'hh';
  },
  fieldMinutesPlaceholder: function fieldMinutesPlaceholder() {
    return 'mm';
  },
  fieldSecondsPlaceholder: function fieldSecondsPlaceholder() {
    return 'ss';
  },
  fieldMeridiemPlaceholder: function fieldMeridiemPlaceholder() {
    return 'aa';
  }
};
export var heIL = getPickersLocalization(heILPickers);